namespace Dzek_Vrabac
{
    internal class Program
    {
        public static void UnosPodataka(out int n, out int[] x, out int[] h)
        {
            n = int.Parse(Console.ReadLine());
            x = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
            h = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
        }

        public static int PostavljanjeNajmanjeUdaljenosti(int trenutnaNajmanjaUdaljenost, int dobijeniRezultat)
        {
            // Ako nadjeno neku udaljenost to je bolja od -1, a ako trenutna udaljenost nije -1 onda uzimamo manju od te dve
            if (trenutnaNajmanjaUdaljenost == -1) return dobijeniRezultat;
            else return Math.Min(trenutnaNajmanjaUdaljenost, dobijeniRezultat);
        }

        public static int NajbliziDeoZaSvakiJarbol(int i, int n, int[] x, int[] h)
        {
            int najmanjaUdaljenost = -1;

            // Poslednji jarbol nema desnog susednog jarbola
            if (i != n - 1)
            {
                // Izracunavanje razlike u visini i udaljenosti izmedju jarbola
                int razlikaUVisini = h[i + 1] - h[i];
                int udaljenostJarbola = x[i + 1] - x[i];

                // Racunanje kolko dugo konopac pada
                int opada = (udaljenostJarbola - razlikaUVisini) / 2;

                // Ako konopac pada manje nego sto raste onda je najmanja udaljenost kada se konnopac vrati na visinu jarbola, ako pada vise onda nije moguce
                if (opada < udaljenostJarbola - opada) najmanjaUdaljenost = PostavljanjeNajmanjeUdaljenosti(najmanjaUdaljenost, 2 * opada);
            }

            // Prvi jarbol nema levog susednog jarbola
            if (i != 0)
            {
                // Izracunavanje razlike u visini i udaljenosti izmedju jarbola
                int razlikaUVisini = h[i] - h[i - 1];
                int udaljenostJarbola = x[i] - x[i - 1];

                // Racunanje kolko dugo konopac pada
                int raste = (udaljenostJarbola + razlikaUVisini) / 2;

                // Ako konopac pada manje nego sto raste onda je najmanja udaljenost kada se konnopac vrati na visinu jarbola, ako pada vise onda nije moguce
                if (raste < udaljenostJarbola - raste) najmanjaUdaljenost = PostavljanjeNajmanjeUdaljenosti(najmanjaUdaljenost, 2 * raste);
            }

            return najmanjaUdaljenost;
        }

        public static int[] NajbliziDeo(int n, int[] x, int[] h)
        {
            // Inicializacija niza za rezultat
            int[] rezultat = new int[n];

            // Racunanje rezultata za svaki jarbol
            for (int i = 0; i < n; i++)
            {
                rezultat[i] = NajbliziDeoZaSvakiJarbol(i, n, x, h);
            }

            return rezultat;
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out int n, out int[] x, out int[] h);

            // Ispis rezultata
            Console.WriteLine(string.Join(' ', NajbliziDeo(n, x, h)));
        }
    }
}